<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Follow;

use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\User\UserFollowTable;

final class UserFollowModel extends AbstractModel implements InterfaceUserFollowGetter
{
    /**
     * getter interface
     */
    use TraitUserFollowGetters;

    public function getTableClassName(): string
    {
        return UserFollowTable::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | helper methods
    |--------------------------------------------------------------------------
    */

    public function isPending(): bool
    {
        return UserFollowEnum::META_IS_PENDING_YES == $this -> getMetaIsPending();
    }
}
